#!/usr/bin/env bash

# Prompt for network interface name
read -p "Enter network interface name: " INTERFACE

echo "Checking if 'ethtool' is installed"
if ! command -v ethtool &> /dev/null; then
  echo "Installing ethtool..."
  dnf install -y ethtool
fi

echo "Disabling Energy Efficient Ethernet (EEE)"
ethtool --set-eee $INTERFACE eee off

echo "Setting Speed & Duplex to Auto-Negotiation"
ethtool -s $INTERFACE speed 1000 duplex full autoneg on

echo "Disabling Power Saving Mode for PCI"
if [ -d "/sys/class/net/$INTERFACE/device/power/control" ]; then
  echo "on" > /sys/class/net/$INTERFACE/device/power/control
fi

echo "Disabling Wake-on-LAN (WoL)"
ethtool -s $INTERFACE wol d

echo "Disabling Low Power Mode and Large Send Offload (LSO)"
ethtool -K $INTERFACE gso off gro off tso off
ethtool -K $INTERFACE lro off

echo "Current settings for interface $INTERFACE"
ethtool $INTERFACE
ethtool -k $INTERFACE

echo "Configuration completed"